# Compliance Checklist: Quick Reference for Treatment Plans & Progress Notes

**Syracuse Integrative Psychiatry**  
**For:** Psychotherapy Add-On Codes 90833 & 90836  
**Date:** January 2026

---

## ✅ NYS OMH Requirements (14 NYCRR § 599.10)

### Treatment Plan Timeframe
- ☐ Initial treatment plan completed within **30 days** for Medicaid Fee-for-Service patients
- ☐ Follow specific payer requirements for other insurance

### Required Treatment Plan Elements
- ☐ **Diagnosis** documented (or reference to assessment document)
- ☐ **Patient strengths and needs** documented
- ☐ **Treatment goals and objectives** included
- ☐ **Primary clinician name and title** listed
- ☐ **Types of personnel** providing services identified
- ☐ **Services and frequency** specified (type, projected frequency, duration)
- ☐ **Special arrangements** documented if applicable (off-site services, linguistic needs)

### Signature Requirements (PMHNP-BC Can Sign)
- ☐ **Medicaid Fee-for-Service**: Signed by psychiatrist, nurse practitioner of psychiatry, or other physician
- ☐ **Other payers with medications**: Signed by psychiatrist, physician, or nurse practitioner in psychiatry
- ☐ **Other payers without medications**: Signed by psychiatrist, physician, psychologist, PMHNP, LCSW, or other licensed practitioner

### Treatment Plan Review
- ☐ Reviewed **at least annually** (or more frequently as determined by clinician)
- ☐ Review includes assessment of progress toward goals
- ☐ Goals, objectives, time periods, or interventions adjusted as needed
- ☐ Input from relevant staff, patient, and family/collaterals obtained

### Treatment Plan Updates
- ☐ Updated when new services added or intensity increased
- ☐ Updated as necessary per treating clinician
- ☐ Updated plan signed by treating clinician

### Patient Participation Documentation
- ☐ **Patient participation** in treatment plan development documented
- ☐ For children: parent, guardian, or legal authority participation documented (and child where appropriate)
- ☐ Family/collaterals specifically identified if participating

### Progress Notes Requirements (Each Session)
- ☐ **Date and duration** of service documented
- ☐ **Location** where service provided documented
- ☐ **Summary of services** provided included
- ☐ **Update on progress** toward goals included
- ☐ **Recommended changes** to treatment plan documented if applicable
- ☐ Whether **collaterals were seen** noted
- ☐ **Name and title** of staff member providing service included

---

## ✅ Medicare Documentation Requirements

### Time Documentation (CRITICAL)
- ☐ **Start and stop times OR total time** documented
- ☐ Time supports code billed:
  - **90833**: 16-37 minutes of psychotherapy
  - **90836**: 38-52 minutes of psychotherapy
- ☐ **Medication management time** separated from **psychotherapy time**
- ☐ Cannot count same time toward both E/M and psychotherapy codes

### Treatment Plan Requirements (Generally Required by MACs)
- ☐ **Type, amount, frequency, duration** of services specified
- ☐ **Patient's diagnosis** documented
- ☐ **Type of service** specified
- ☐ **Expectation of improvement** OR maintenance of functioning documented
- ☐ **Periodic summary** of goals and progress included
- ☐ **Detailed summary** of session with therapeutic interventions documented
- ☐ **Patient's capacity** to participate in psychotherapy documented

### Additional Documentation
- ☐ **Provider signature** on medical record
- ☐ **Service modality** indicated (in-person or telehealth)
- ☐ **Appropriate place of service code** and modifiers used for telehealth

---

## ✅ Carelon Behavioral Health Requirements

### General Documentation Standards
- ☐ Documentation **completed and signed after session**
- ☐ Documentation is **legible**
- ☐ **Signature** of provider included
- ☐ Documentation completed **prior to claim submission**
- ☐ Amendments/changes **signed and dated** by clinician
- ☐ Each record is **individualized and unique** (no cloning/copying)

### Treatment Plan Requirements
- ☐ **Service requirements** indicating completion
- ☐ **Treatment plan date** documented
- ☐ **Diagnoses and/or symptoms** being addressed included
- ☐ **Clinician's signature, credentials, and date** included
- ☐ **Member or guardian's signature and date** included (or acknowledgement of participation)
- ☐ **Evidence of member/guardian participation** in plan development documented
- ☐ **Goals and objectives** based on evaluation and mental health strengths/needs
- ☐ Treatment objectives prescribed as **integrated program** of therapies
- ☐ Treatment plan has **measurable goals**
- ☐ Treatment plan has **established timeframes**
- ☐ **Less restrictive alternatives** considered and documented
- ☐ Treatment plan is **easy to read and understand**
- ☐ Treatment plan **documents necessity for services**
- ☐ Treatment plan **documents utilization of services**
- ☐ Treatment plan **reviewed in accordance with clinical standards**

### Progress Notes Requirements (Each Session)
- ☐ Each **billable encounter** represented
- ☐ **Name or member ID** included
- ☐ **Date of service matches claim** billed
- ☐ **Duration or start/stop times** documented
- ☐ **Units match claims billing** and supported by time
- ☐ **Place of service** on claim supported in documentation
- ☐ **Reason(s) for session** documented
- ☐ Documentation **supports procedure code** billed (90833/90836 definition)
- ☐ **Treatment plan goals addressed** referenced
- ☐ **Current symptoms and behaviors** documented
- ☐ **Interventions and response** to treatment documented
- ☐ **Next steps and progress** documented
- ☐ **Narrative with clinical justification** supports utilization and time billed
- ☐ **Clinician's signature, credentials, and date** included

---

## ✅ Aetna & Cigna Requirements

### Medical Necessity
- ☐ **Medical necessity** clearly documented
- ☐ Treatment is **evidence-based** (ACT is evidence-based)

### SMART Goals
- ☐ Goals are **Specific**
- ☐ Goals are **Measurable**
- ☐ Goals are **Achievable**
- ☐ Goals are **Relevant**
- ☐ Goals are **Time-bound**

### Progress Documentation
- ☐ **Progress toward goals** documented at each visit
- ☐ Goals updated when achieved or modified as needed

---

## 🚨 Common Audit Findings to AVOID

### Most Common Documentation Errors:
- ❌ **Lack of time documentation** (start/stop times or total time)
- ❌ **Incomplete treatment plans** (missing required elements)
- ❌ **Missing signatures** (provider or patient)
- ❌ **Failure to differentiate** in-person vs. telehealth
- ❌ **Vague interventions** ("supportive therapy" without specifics)
- ❌ **Copy/paste documentation** (not individualized)
- ❌ **Time doesn't support code** billed
- ❌ **No connection** to treatment plan goals in progress notes
- ❌ **Missing clinical justification** for time billed
- ❌ **No documentation** of patient participation in treatment planning

---

## 📋 Quick Pre-Session Checklist

### Before Each Session:
- ☐ Review patient's current treatment plan
- ☐ Note which goals to address today
- ☐ Prepare ACT interventions aligned with goals

### During Session:
- ☐ Note start time
- ☐ Separate medication management from psychotherapy activities
- ☐ Use specific ACT interventions (not vague "supportive therapy")
- ☐ Connect interventions to patient's values
- ☐ Note end time

### After Session (Document Immediately):
- ☐ **Date of service**
- ☐ **Start and stop times** (or total time)
- ☐ **Time breakdown**: ___ min medication management, ___ min psychotherapy
- ☐ **Current symptoms and mental status**
- ☐ **Treatment plan goals addressed** (reference specific goals)
- ☐ **Specific ACT interventions used** (name the ACT process and technique)
- ☐ **Patient's values** referenced
- ☐ **Committed actions** patient agreed to
- ☐ **Patient's response** to interventions
- ☐ **Progress toward goals** (improving psychological flexibility?)
- ☐ **Clinical justification** for time billed
- ☐ **Next steps/homework** assigned
- ☐ **Provider signature with credentials and date**
- ☐ **Location** (in-person or telehealth)

---

## 📋 Quick Pre-Billing Checklist

### Before Submitting Claims:
- ☐ Time documented supports code billed (90833: 16-37 min, 90836: 38+ min)
- ☐ Progress note references treatment plan goals
- ☐ Specific ACT interventions documented (not vague)
- ☐ Clinical justification supports medical necessity
- ☐ Note is signed with credentials and date
- ☐ Note is individualized (not copy/paste)
- ☐ Place of service matches claim
- ☐ Date of service matches claim
- ☐ E/M code + psychotherapy add-on code combination is valid

---

## 📋 Treatment Plan Review Checklist (Every 90 Days Minimum)

### Review and Update:
- ☐ Assess progress toward each goal
- ☐ Update goals if achieved or modify if not progressing
- ☐ Adjust ACT interventions based on what's working
- ☐ Update medications if changes made
- ☐ Reassess barriers and adjust strategies
- ☐ Update discharge criteria based on progress
- ☐ Document patient participation in review
- ☐ Obtain new signatures (provider and patient)
- ☐ Date the updated plan
- ☐ Set reminder for next 90-day review

---

## 🎯 ACT Documentation Quick Tips

### Always Document:
1. **Which ACT process** used (acceptance, defusion, present moment, self-as-context, values, committed action)
2. **Specific ACT technique** (not just "ACT therapy")
3. **Patient's values** and how interventions connect to values
4. **Committed actions** patient agreed to take
5. **Progress in psychological flexibility** (not just symptom scores)

### Use ACT-Specific Language:
- "Practiced willingness to experience [emotion] without avoidance"
- "Patient practiced defusion with thought '[specific thought]' by labeling as 'I'm having the thought that...'"
- "Patient identified [value] and committed to [action] in service of this value"
- "Patient chose values over comfort by committing to [action]"
- "Patient demonstrating increased psychological flexibility"

---

## 📞 Audit Support Resources

### If Audited:
- **Medicare:** Contact your MAC (Medicare Administrative Contractor)
- **Carelon BH:** Review Payment Integrity Provider Documentation Standards
- **NYS OMH:** www.omh.ny.gov
- **APNA:** www.apna.org (professional support)

---

## ⏰ Set Reminders

### Calendar Reminders to Set:
- ☐ **30 days after patient admission**: Complete initial treatment plan (Medicaid)
- ☐ **90 days after treatment plan**: Review and update treatment plan
- ☐ **Every 90 days**: Ongoing treatment plan reviews
- ☐ **Annually**: Minimum treatment plan review (NYS OMH requirement)

---

**This checklist ensures compliance with Medicare, NYS OMH, Carelon BH, Aetna, and Cigna requirements for treatment plans and psychotherapy add-on codes 90833/90836.**

**Keep this checklist accessible during documentation to ensure all required elements are included!**

---

**Version:** 1.0  
**Date:** January 2026  
**Prepared for:** Syracuse Integrative Psychiatry  
**Compliance Standards:** Medicare, NYS OMH 14 NYCRR § 599.10, Carelon BH, Aetna, Cigna
