# ACT Patient Handouts & Worksheets

**Syracuse Integrative Psychiatry**  
**Prepared for:** Psychotherapy Add-On Codes 90833 & 90836  
**Therapeutic Modality:** Acceptance and Commitment Therapy (ACT)  
**Date:** January 2026

---

## Package Contents

This comprehensive package includes professionally designed, branded patient handouts and worksheets for practicing ACT interventions at home. All materials feature the Syracuse Integrative Psychiatry logo and are ready to print or share digitally with patients.

### Core ACT Educational Materials

**1. ACT_Core_Skills_Handout.html**
- Overview of the six core ACT processes
- Explanation of psychological flexibility
- Practice exercises for each process
- What ACT is and is NOT
- **Use:** Give to all new patients as introduction to ACT approach

**2. Values_Clarification_Worksheet.html**
- Comprehensive values exploration across life domains
- Guided questions for identifying personal values
- Reflection exercises
- **Use:** Complete with patients in session or assign as homework; essential for ACT treatment planning

**3. Defusion_Techniques_Handout.html**
- 10 specific defusion techniques with examples
- Understanding fusion vs. defusion
- Practice log for tracking defusion practice
- **Use:** Give after introducing defusion concept; reference for home practice

### Condition-Specific ACT Worksheets

**4. Depression_ACT_Worksheet.html**
- Defusing from depressive thoughts
- Acceptance of depressive feelings
- Values-based behavioral activation
- Self-compassion practice
- Weekly action plan
- **Use:** For patients with Major Depressive Disorder; complete collaboratively in session

**5. Anxiety_ACT_Worksheet.html**
- Defusing from "what if" thoughts
- Willingness to experience anxiety (expansion practice)
- Values-based exposure planning
- Willingness practice ladder
- Accepting uncertainty
- Dropping safety behaviors
- **Use:** For patients with Generalized Anxiety Disorder, Panic Disorder, Social Anxiety, or specific phobias

### Additional Materials (To Be Used Based on Session Work)

**6. ADHD_ACT_Worksheet.html** *(Create if needed)*
- Self-compassion for ADHD
- Defusing from self-critical thoughts
- Values-based task completion
- Working with ADHD brain, not against it

**7. Bipolar_ACT_Worksheet.html** *(Create if needed)*
- Acceptance of bipolar disorder
- Mood monitoring with acceptance
- Medication adherence as committed action
- Routine as values-based behavior

**8. OCD_ACT_Worksheet.html** *(Create if needed)*
- Defusing from obsessions
- Willingness to experience uncertainty
- Values-based exposure (not anxiety reduction)
- Response prevention as committed action

**9. Committed_Action_Tracker.html** *(Create if needed)*
- Weekly tracking of values-based actions
- Reflection on barriers and successes
- Building consistency in valued living

**10. Willingness_Practice_Log.html** *(Create if needed)*
- Daily log for practicing willingness
- Tracking uncomfortable experiences approached
- Progress in psychological flexibility

---

## How to Use These Materials

### In Session:
1. **Introduce ACT concepts** using the Core Skills Handout
2. **Complete Values Clarification Worksheet** collaboratively with patient
3. **Teach defusion techniques** using the Defusion Techniques Handout
4. **Assign condition-specific worksheet** based on patient's diagnosis
5. **Review completed worksheets** at next session and adjust treatment plan

### As Homework:
- Assign relevant worksheets between sessions
- Ask patients to bring completed worksheets to next appointment
- Use worksheet responses to guide session content
- Track progress in values-based living and psychological flexibility

### For Documentation:
- Reference specific worksheets in progress notes
- Document which ACT skills patient practiced at home
- Note patient's responses to worksheet exercises
- Use worksheet content to demonstrate progress toward treatment goals

---

## Printing and Distribution

### Printing Recommendations:
- **Print in color** for best appearance (logo and design elements)
- **Paper:** Standard 8.5" x 11" letter size
- **Quality:** Recommend high-quality paper for professional appearance
- **Binding:** Can be hole-punched for patient binders

### Digital Distribution:
- **Email:** Send HTML files directly to patients
- **Patient Portal:** Upload to secure patient portal if available
- **Print to PDF:** Convert HTML to PDF for easy sharing

### Customization:
- Logo is embedded in each file
- Contact information is included in header
- Files can be edited in any HTML editor if customization needed

---

## Clinical Tips for Using ACT Worksheets

### Start with Values:
Always begin ACT work with values clarification. Values are the foundation of all ACT interventions. Without clear values, committed action has no direction.

### Emphasize Experiential Learning:
ACT is best learned through experience, not just reading. Use worksheets as starting points for in-session experiential exercises.

### Normalize Difficulty:
Let patients know that ACT skills feel awkward at first. Psychological flexibility improves with practice.

### Connect to Treatment Goals:
Always connect worksheet exercises to patient's treatment plan goals. Show how practicing these skills moves them toward their goals.

### Review Homework:
Always review completed worksheets at the next session. This reinforces the importance of home practice and allows you to address questions or difficulties.

### Document Thoroughly:
Reference specific worksheets and exercises in your progress notes to demonstrate evidence-based treatment and support billing for psychotherapy add-on codes.

---

## ACT Documentation Language for Progress Notes

When patients complete these worksheets, document using ACT-specific language:

**Example Progress Note:**
> "Patient completed Values Clarification Worksheet as homework. Identified core values of being a caring parent and maintaining close friendships. Worked on defusion from depressive thought 'I'm worthless' using techniques from Defusion Handout. Patient practiced labeling thought as 'I'm having the thought that I'm worthless' and reported feeling less fused with thought. Assigned Depression ACT Worksheet for home practice; patient will complete values-based behavioral activation plan and engage in two values-based activities this week despite low mood."

---

## Frequently Asked Questions

**Q: Should I give all handouts to every patient?**  
A: No. Start with Core Skills Handout and Values Clarification Worksheet for all patients. Then assign condition-specific worksheets based on diagnosis and treatment focus.

**Q: What if patients don't complete homework?**  
A: Explore barriers with curiosity, not judgment. Sometimes completing worksheets in session works better. Use the worksheet as a guide for discussion even if not fully completed.

**Q: Can I modify these worksheets?**  
A: Yes! These are templates. Feel free to customize based on individual patient needs while maintaining the core ACT principles.

**Q: How do I know if ACT is working?**  
A: Look for increased psychological flexibility: Is the patient taking values-based action despite difficult thoughts/feelings? Are they less avoidant? More engaged in meaningful activities? Use AAQ-II (Acceptance and Action Questionnaire) to measure psychological flexibility quantitatively.

**Q: What if patients want to eliminate symptoms, not just accept them?**  
A: This is a common initial resistance to ACT. Gently educate that paradoxically, acceptance often leads to symptom reduction, but that's not the primary goal. The goal is valued living. Use "creative hopelessness" to explore whether control strategies have worked long-term.

---

## Additional Resources for Patients

### Recommended Books:
- **"The Happiness Trap" by Russ Harris** - Excellent patient-friendly ACT introduction
- **"Get Out of Your Mind and Into Your Life" by Steven Hayes** - Original ACT self-help book
- **"The Mindfulness and Acceptance Workbook for Depression"** by Strosahl & Robinson
- **"The Mindfulness and Acceptance Workbook for Anxiety"** by Forsyth & Eifert

### Websites:
- **The Happiness Trap:** www.thehappinesstrap.com
- **ACT Mindfully:** www.actmindfully.com.au
- **Association for Contextual Behavioral Science:** www.contextualscience.org

### Apps:
- **ACT Coach** (free, evidence-based)
- **ACT Companion** (guided ACT exercises)

---

## Support

For questions about these materials or ACT implementation:

**Syracuse Integrative Psychiatry**  
5108 Velasko Road, Suite 2000  
Syracuse, NY 13215  
www.syracuseintegrativepsychiatry.com

---

## Version Information

**Version:** 1.0  
**Date Created:** January 2026  
**Created for:** Syracuse Integrative Psychiatry  
**Therapeutic Modality:** Acceptance and Commitment Therapy (ACT)  
**Compliance:** Materials designed to support treatment plans compliant with Medicare, NYS OMH, Carelon BH, Aetna, and Cigna requirements

---

**All materials © 2026 Syracuse Integrative Psychiatry. These handouts are for educational purposes and are designed to supplement, not replace, professional mental health care.**
